/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ResponseFilter.java 71666 2013-04-19 13:14:27Z supol $
 */

package com.sun.ts.tests.jaxrs.spec.provider.exceptionmapper;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
public class ResponseFilter implements ContainerResponseFilter {

	@Override
	public void filter(ContainerRequestContext requestContext,
			ContainerResponseContext responseContext) throws IOException {
		Object objectEntity = responseContext.getEntity();
		if (objectEntity != null) {
			String entity = objectEntity.toString();
			// Affect only one single test of JAXRS:SPEC:82;
			if (entity.equals(FilterChainTestExceptionMapper.class.getName()))
				responseContext.setEntity(getClass().getName(),
						(Annotation[]) null, responseContext.getMediaType());
		}
	}

}
