/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.overridestandard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(MediaType.APPLICATION_FORM_URLENCODED)
@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
public class TckMapProvider extends AbstractProvider implements
		MessageBodyReader<MultivaluedMap<String, String>>,
		MessageBodyWriter<MultivaluedMap<String, String>> {

	@Override
	public long getSize(MultivaluedMap<String, String> t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType) {
		return getLength();
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return MultivaluedMap.class.isAssignableFrom(type);
	}

	@Override
	public void writeTo(MultivaluedMap<String, String> t, Class<?> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(t.getFirst(getClass().getSimpleName()).getBytes());
		entityStream.write(getWriterName().getBytes());
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return isWriteable(type, genericType, annotations, mediaType);
	}

	@Override
	public MultivaluedMap<String, String> readFrom(
			Class<MultivaluedMap<String, String>> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		MultivaluedMap<String, String> map = new MultivaluedHashMap<String, String>();
		map.add(getClass().getSimpleName(), getReaderName());
		return map;
	}

}
