/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: MediaResource.java 69883 2013-02-07 17:16:47Z supol $
 */

package com.sun.ts.tests.jaxrs.spec.resource.responsemediatype;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Produces(MediaType.TEXT_HTML)
@Path("resource")
public class MediaResource {

	@GET
	@Path("responseoverride")
	@Produces(MediaType.APPLICATION_FORM_URLENCODED)
	public Response override() {
		return Response.ok(" ").type(MediaType.APPLICATION_XML_TYPE).build();
	}
		
	@GET
	@Path("method")
	@Produces(MediaType.APPLICATION_ATOM_XML)
	public Response method(){
		return Response.ok(" ").build();
	}
	
	@GET
	@Path("class")
	public Response clazz(){
		return Response.ok(" ").build();
	}
	
	@POST
	@Produces("text/plain")
	public String plain() {
		return MediaType.TEXT_PLAIN;
	}

	@POST
	public String html(@Context Request req) {
		return MediaType.TEXT_HTML;
	}

	@POST
	@Produces("text/xml")
	public String xml() {
		return MediaType.TEXT_XML;
	}
	
	@POST
	@Produces("application/*")
	public String app() {
		return MediaType.WILDCARD;
	}
	
	@POST
	@Produces("application/xml")
	public String appxml() {
		return MediaType.APPLICATION_XML;
	}	

	@POST
	@Produces("image/png")
	public String png() {
		return "image/png";
	}
	
	@POST
	@Produces("image/*")
	public String image() {
		return "image/any";
	}	
	
}
