/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BOMVerifier
extends Task {
    private File zipfile;
    private File bomfile;
    private File bomfile2;
    private List includesfiles = new ArrayList();
    private List excludesfiles = new ArrayList();
    private List bomlist1;

    public void setZipfile(File f) {
        this.zipfile = f;
    }

    public void setBomfile(File f) {
        this.bomfile = f;
    }

    public void setBomfile2(File f) {
        this.bomfile2 = f;
    }

    public void setIncludesfiles(String s) {
        this.addFileNames(this.includesfiles, s);
    }

    public void setExcludesfiles(String s) {
        this.addFileNames(this.excludesfiles, s);
    }

    private void addFileNames(List fl, String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            fl.add(token);
        }
    }

    private void validateAttrs() {
    }

    private void initItems(List fileNames, List items, File baseDir) throws IOException {
        int n = fileNames.size();
        for (int i = 0; i < n; ++i) {
            String fileName = (String)fileNames.get(i);
            File file = new File(baseDir, fileName);
            if (!file.exists()) {
                this.log("File does not exist:" + fileName);
                continue;
            }
            this.readFile2List(file, items);
        }
    }

    protected void verifyBomfile(File bfile) {
        String bomPath = this.bomfile.getPath();
        File baseDir = this.project.getBaseDir();
        ArrayList includesItems = new ArrayList();
        ArrayList excludesItems = new ArrayList();
        try {
            this.initItems(this.includesfiles, includesItems, baseDir);
            this.initItems(this.excludesfiles, excludesItems, baseDir);
            if (this.bomlist1 == null) {
                this.bomlist1 = new ArrayList(1000);
                this.readFile2List(this.bomfile, this.bomlist1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (this.bomlist1.containsAll(includesItems)) {
            this.log("All required files are included in " + bomPath);
        } else {
            includesItems.removeAll(this.bomlist1);
            this.log("WARNING: missing " + includesItems.size() + " files in " + bomPath + ":");
            this.printList(includesItems);
        }
        this.bomlist1.retainAll(excludesItems);
        if (this.bomlist1.size() == 0) {
            this.log("All files that should be excluded are excluded in  " + bomPath);
        } else {
            this.log("WARNING: " + this.bomlist1.size() + " files are not excluded in " + bomPath + ":");
            this.printList(this.bomlist1);
        }
    }

    protected void verifyZipfile(File zfile) {
        this.log("Please generate BOM first.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile2List(File file, List list) throws IOException {
        if (list == null) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void compareBoms(File b1, File b2) {
        if (b2 == null) {
            return;
        }
        if (b1 == null) {
            this.log("bomfile not set and cannot compare to bomfile2 " + b2.getPath());
            return;
        }
        if (!b1.isFile() || !b2.isFile()) {
            this.log("bomfile or bomfile2 is not a regular file. Abort ...");
            return;
        }
        List list1 = null;
        ArrayList list2 = null;
        try {
            if (this.bomlist1 == null) {
                this.bomlist1 = new ArrayList(1000);
                this.readFile2List(this.bomfile, this.bomlist1);
                list1 = this.bomlist1;
            } else {
                list1 = this.bomlist1;
            }
            list2 = new ArrayList(1000);
            this.readFile2List(this.bomfile2, list2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        int size1 = list1.size();
        int size2 = list2.size();
        ArrayList common = null;
        if (size1 < size2) {
            common = new ArrayList(list1);
            if (!common.retainAll(list2)) {
                this.log("After reading in 2 BOM files, failed to get common entries between");
                return;
            }
        } else {
            common = new ArrayList(list2);
            if (!common.retainAll(list1)) {
                this.log("After reading in 2 BOM files, failed to get common entries between");
                return;
            }
        }
        if (!list1.removeAll(common)) {
            this.log("After reading in 2 BOM files and getting the common entries, failed to get unique entries in bomfile1");
            return;
        }
        if (!list2.removeAll(common)) {
            this.log("After reading in 2 BOM files and getting the common entries, failed to get unique entries in bomfile2");
            return;
        }
        this.displayComparison(list1, list2);
    }

    private void displayComparison(List list1, List list2) {
        int size1 = list1.size();
        int size2 = list2.size();
        String path1 = this.bomfile.getPath();
        String path2 = this.bomfile2.getPath();
        if (size1 == 0) {
            if (size2 == 0) {
                this.log("2 bomfiles are identical:\n" + path1 + "\n" + path2);
            } else {
                this.log("All entries in " + path1 + " are in " + path2 + "\n\n" + size2 + " entries in " + path2 + " are not in " + path1 + ":");
                this.printList(list2);
            }
        } else if (size2 == 0) {
            this.log("All entries in " + path2 + " are in " + path1 + "\n\n" + size1 + " entries in " + path1 + " are not in " + path2 + ":");
            this.printList(list1);
        } else {
            this.log(size1 + " entries in " + path1 + " are not in " + path2 + ":");
            this.printList(list1);
            this.log(size2 + " entries in " + path2 + " are not in " + path1 + ":");
            this.printList(list2);
        }
    }

    private void printList(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.log("\t" + (String)list.get(i));
        }
        this.log("* * * * * * * * * * * * * * * * * *\n");
    }

    public void execute() throws BuildException {
        this.validateAttrs();
        if (this.zipfile == null) {
            if (this.bomfile == null) {
                throw new BuildException("Specify zipfile or bomfile or both.");
            }
            this.verifyBomfile(this.bomfile);
        } else if (this.bomfile == null) {
            this.verifyZipfile(this.zipfile);
        } else {
            this.verifyBomfile(this.bomfile);
        }
        this.compareBoms(this.bomfile, this.bomfile2);
    }
}

