/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FaultTestClient.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.sharedclients.faultclient;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class FaultTestClient extends SOAPClient {

    public FaultTestClient(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }
    public FaultTestClient(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://faulttestservice.org/wsdl");
        stubContext.setService("FaultTest");
        stubContext.setPort("SoapFaultTestPort");
        stubContext.setEndpointInterface(SoapFaultTest.class);
        stubContext.setWebServiceRef(webServiceRef);

    }

    public String getEndpointURLProperty() {
        return "wsi.fault.endpoint.1";
    }

    public String getWSDLURLProperty() {
        return "wsi.fault.wsdlloc.1";
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailNoChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailQualifiedChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailUnqualifiedChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailUnqualifiedChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoAttributes() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailNoAttributes();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedAttributes() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailQualifiedAttributes();
    }
}
