/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AddNumbersImpl3.java 52501 2007-01-24 02:29:49Z adf $
 */

package com.sun.ts.tests.jaxws.wsa.j2w.document.literal.anonymous;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import javax.jws.WebService;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.HandlerChain;
import javax.xml.ws.Action;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;

@WebService(
    name="AddNumbersPortType3",
    portName="AddNumbersPort3",
    serviceName="AddNumbersService3",
    targetNamespace="http://example.com/"
)

@Addressing(enabled=true, required=true, responses=AddressingFeature.Responses.ANONYMOUS)
@HandlerChain(name="", file="server-handler.xml")
public class AddNumbersImpl3 {

    @Action(
        input="http://example.com/AddNumbersPortType3/add",
        output="http://example.com/AddNumbersPortType3/addResponse")
    @WebMethod
    public int addNumbers(
	@WebParam(name="number1", targetNamespace="http://example.com/") int number1,
        @WebParam(name="number2", targetNamespace="http://example.com/") int number2,
        @WebParam(name="testName", targetNamespace="http://example.com/") String testName) throws AddNumbersException {

        if (number1 < 0 || number2 < 0) {
	    throw new AddNumbersException("Negative numbers can't be added!",
                                          "Numbers: " + number1 + ", " + number2);
        }
        return number1 + number2;
    }
}
