/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JDLR2707Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.R2707;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JDLR2707Client extends SOAPClient {

    public W2JDLR2707Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public W2JDLR2707Client(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jdlr2707testservice.org/W2JDLR2707TestService.wsdl");
        stubContext.setService("W2JDLR2707TestService");
        stubContext.setPort("W2JDLR2707TestPort");
        stubContext.setEndpointInterface(W2JDLR2707Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jdlr2707.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jdlr2707.wsdlloc.1";
    }

    public String echoString(String str) throws Exception {
	Header hdr = new Header();
	hdr.setTestName("echoString");
	hdr.setMessage("Testing echoString method call");
        return ((W2JDLR2707Test)stubContext.getStub()).echoString(str, hdr);
    }
}
