/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2753;

import com.sun.ts.lib.harness.*;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.wsi.constants.WSIConstants;
import com.sun.javatest.Status;

import java.util.Properties;

public class Client extends ServiceEETest implements WSIConstants{

    private W2JRLR2753Client client;

    
    static SimpleTest service = null;

    /**
     * Test entry point.
     *
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }


    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void setup(String[] args, Properties properties) throws EETest.Fault {
        client = (W2JRLR2753Client)ClientFactory.getClient(W2JRLR2753Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup(){
        logMsg("cleanup");
    }

    /**
     * @testName: testExtraMustUnderstandHeader
     *
     * @assertion_ids: WSI:SPEC:R12753; JAXWS:SPEC:9001
     *
     * @test_Strategy: Make a request and add a header not contained
     * in the wsdl, and set it to 'mustUnderstand=1'. Ensure the request and response are normal.
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void testExtraMustUnderstandHeader() throws EETest.Fault {
        String response = "";
        try{
            response = client.helloWorld();
        }catch(Exception e){
            TestUtil.printStackTrace(e);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if(!response.equals("hello world")){
            throw new EETest.Fault("Error creating response object:" + response);
        }
    }
}
