/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common.schema30;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

/*
 * SoftwareProduct
 */


@Entity
@DiscriminatorValue("SW")
public class SoftwareProduct extends Product
        implements java.io.Serializable {

    // Instance variables
    private double revisionNumber;

    public SoftwareProduct() {
        super();
    }


    // ===========================================================
    // getters and setters for the state fields

    @Column(name = "REV", nullable = true)
    public double getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(double revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("revisionNumber: " + getRevisionNumber());
        result.append(", name: " + getName());
        result.append(", price: " + getPrice());
        result.append(", quantity: " + getQuantity());
        result.append(", partNumber: " + getPartNumber());
        result.append(", wareHouse: " + getWareHouse());
        result.append("]");
        return result.toString();
    }
}
