/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common.schema30;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/*
 * Trim
 */

@Entity
@Table(name = "TRIM_TABLE")
public class Trim implements java.io.Serializable {

    // Instance variables
    private String id;
    private String name;


    public Trim() {
    }

    public Trim(String id, String name) {
        this.id = id;
        this.name = name;
    }

    // ===========================================================
    // getters and setters for CMP fields

    @Id
    @Column(name = "ID")
    public String getId() {
        return id;
    }

    public void setId(String v) {
        this.id = v;
    }

    @Column(name = "NAME")
    public String getName() {
        return name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean equals(Object o) {
        Trim other;
        boolean same = true;

        if (!(o instanceof Trim)) {
            return false;
        }
        other = (Trim) o;

        same &= this.id.equals(other.id);

        return same;
    }


    public int hashCode() {
        int myHash;

        myHash = this.id.hashCode();

        return myHash;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(",  name: |" + getName() + "|");
        result.append("]");
        return result.toString();
    }
}
