/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

package com.sun.ts.tests.jpa.core.annotations.access.property;

import javax.persistence.*;

@Entity
@Table(name = "DATATYPES2")
@Access(AccessType.PROPERTY)
public class DataTypes2 implements java.io.Serializable {
    
    private java.util.Date id;
    private java.sql.Time timeData;
    private java.sql.Timestamp tsData;

    
    public DataTypes2()
    {
    }

    public DataTypes2(java.util.Date id) {
	this.id = id;
    }

    public DataTypes2(java.util.Date id, java.sql.Time timeData,
			java.sql.Timestamp tsData)
    {
	this.id = id;

        this.timeData = timeData;
        this.tsData = tsData;
    }

   @Id
   @Column(name = "DATATYPES2_ID")
   @Temporal(TemporalType.DATE)
   public java.util.Date getId()
   {
      return id;
   }
   public void setId(java.util.Date id)
   {
      this.id= id;
   }
   

    
   @Column(name = "TIMEDATA")
   public java.sql.Time getTimeData(){
      return timeData;
   }
   public void setTimeData(java.sql.Time timeData)
   {
      this.timeData = timeData;
   }

   @Column(name = "TSDATA")
   public java.sql.Timestamp getTsData() {
       return tsData;
   }
   public void setTsData(java.sql.Timestamp tsData)
   {
      this.tsData = tsData;
   }
    

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getTimeData() != null) {
            result.append(", TimeData: " + getTimeData());
        } else {
            result.append(", TimeData: null");
        }
        if (getTsData() != null) {
            result.append(", Timestamp: " + getTsData());
        } else {
            result.append(", Timestamp: null");
        }
        result.append("]");
        return result.toString();
    }

}
