/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.assocoverride;

import javax.persistence.*;
import java.sql.Date;

/*
 * PartTimeEmployee entity extends an MappedSuperClass while overriding
 * Association.
 */
@Entity
@Table(name = "PARTTIMEEMPLOYEE")
@AssociationOverride(name = "address", joinColumns = @JoinColumn(name = "ADDRESS_ID"))
public class PartTimeEmployee extends Employee {

    private float wage;

    public PartTimeEmployee() {
    }

    public PartTimeEmployee(int id, String firstName, String lastName, Date hireDate,
            float salary) {
        super(id, firstName, lastName, hireDate);
        this.wage = wage;
    }


    // ===========================================================
    // getters and setters for the state fields
    @Column(name = "SALARY")
    public float getWage() {
        return wage;
    }

    public void setWage(float wage) {
        this.wage = wage;
    }
}
