/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

 
package com.sun.ts.tests.jpa.core.annotations.mapkeyenumerated;

import javax.persistence.*;
import java.util.Map;

@Entity
@Table(name="DEPARTMENT")
public class Department2 implements java.io.Serializable {

    // Instance variables
    private int  id;
    private String  name;
    private Map<Offices, Employee2> lastNameEmployees;

    public Department2() {
    }

    public Department2(int id, String name) {
        this.id = id;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields

    @OneToMany(mappedBy="department")
    @MapKeyColumn(name="OFFICE_ID")
    @MapKeyEnumerated()
    public Map<Offices, Employee2> getLastNameEmployees() {
        return lastNameEmployees;
    }

    public void setLastNameEmployees(Map<Offices, Employee2> lastNameEmployees) {
        this.lastNameEmployees = lastNameEmployees;
    }

}
