/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.temporal;


import javax.persistence.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "A_BASIC")
public class A_Property implements java.io.Serializable {

    protected String id;
    protected Date basicDate;
    protected Calendar basicCalendar;
    private List<Calendar> dates = new ArrayList<Calendar>();
    public A_Property() {
    }

    public A_Property(String id, Date basicDate, Calendar basicCalendar) {

        this.id = id;
        this.basicDate = basicDate;
        this.basicCalendar = basicCalendar;

    }

    public A_Property(String id, Date basicDate, Calendar basicCalendar, List<Calendar> dates) {
        this.id = id;
        this.basicDate = basicDate;
        this.basicCalendar = basicCalendar;
        this.dates = dates;
    }

    @Id
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Basic
    @Temporal(TemporalType.DATE)
    public Calendar getBasicCalendar() {
        return basicCalendar;
    }

    public void setBasicCalendar(Calendar basicCalendar) {
        this.basicCalendar = basicCalendar;
    }

    @Basic
    @Temporal(TemporalType.DATE)
    public Date getBasicDate() {
        return basicDate;
    }

    public void setBasicDate(Date basicDate) {
        this.basicDate = basicDate;
    }

    @ElementCollection
    @CollectionTable(
            name="DATES_TABLE",
            joinColumns=@JoinColumn(name="ID")
    )
    @Temporal(TemporalType.DATE)
    @Column(name="DATES")
    public List<Calendar> getDates() {
        return dates;
    }

    public void setDates(List<Calendar> dates) {
        this.dates = dates;
    }

    public boolean equals(Object o) {
        A_Property other;
        boolean result = false;

        if (!(o instanceof A_Property)) {
            return result;
        }
        other = (A_Property) o;

        if (this.getId().equals(other.getId()) &&
                this.getBasicCalendar().equals(other.getBasicCalendar()) &&
                this.getBasicDate().equals(other.getBasicDate())
                ) {
            result = true;
        }

        return result;
    }


    public int hashCode() {
        int myHash;

        myHash = this.getId().hashCode() + this.getBasicCalendar().hashCode()+
                  this.getBasicDate().hashCode() ;

        return myHash;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", date: " + getBasicDate());
        result.append(", calendar: " + getBasicCalendar());
        result.append("]");
        return result.toString();
    }
}
