/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: PartProduct.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.inheritance;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;

@Entity
@DiscriminatorValue("PartProduct")
@EntityListeners(com.sun.ts.tests.jpa.core.callback.inheritance.PartProductListener.class)
public class PartProduct extends Product 
        implements java.io.Serializable, CallbackStatusIF {
    private long partNumber;
    
    public PartProduct() {
        super();
    }
    
    @Column(name="PNUM")
    public long getPartNumber() {
        return partNumber;
    }
    public void setPartNumber(long v) {
        this.partNumber = v;
    }
}
