/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LineItem.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.listener;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.ListenerB;
import com.sun.ts.tests.jpa.core.callback.common.ListenerC;

import javax.persistence.*;

@Entity
@Table(name="LINEITEM_TABLE")
@EntityListeners({ListenerB.class, ListenerC.class})
@ExcludeDefaultListeners()
@ExcludeSuperclassListeners
public class LineItem extends LineItemSuper
        implements java.io.Serializable, CallbackStatusIF {
    private String id;
    
//    moved to LineItemSuper
//    private int quantity;
    
    private Order order;
    private Product product;
    
    public LineItem() {
    }
    
    public LineItem(String v1, int v2, Order v3, Product v4) {
        id = v1;
        quantity = v2;
        order = v3;
        product = v4;
    }
    
    public LineItem(String v1, int v2) {
        id = v1;
        quantity = v2;
    }
    
    @Id
    @Column(name="ID")
    public String getId() {
        return id;
    }
    public void setId(String v) {
        id = v;
    }
    
//    moved to LineItemSuper
//    @Column(name="QUANTITY")
//    public int getQuantity() {
//        return quantity;
//    }
//    
//    public void setQuantity(int v) {
//        quantity = v;
//    }
    
    @ManyToOne
    @JoinColumn(name="FK1_FOR_ORDER_TABLE")
    public Order getOrder() {
        return order;
    }
    public void setOrder(Order v) {
        order = v;
    }
    
    @ManyToOne
    @JoinColumn(name="FK_FOR_PRODUCT_TABLE")
    public Product getProduct() {
        return product;
    }
    public void setProduct(Product v) {
        product = v;
    }
}
