/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.nestedembedding;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

@Entity
@Table(name = "ANE_1XM_BI_BTOB")
public class A implements java.io.Serializable {
    // ===========================================================
    // instance variables 
    @Id
    protected String id;
    @Basic
    protected String name;
    @Basic
    protected int value;
    // ===========================================================
    // constructors
    public A() {
        //TestUtil.logTrace("Entity A no arg constructor");
    }

    public A(String id, String name, int value) {
        this.id = id;
        this.name = name;
        this.value = value;
    }

    public A(String id, String name, int value, Collection bCol) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.bCol = bCol;
    }    // ===========================================================
    // relationship fields
    @OneToMany(targetEntity = com.sun.ts.tests.jpa.core.nestedembedding.B.class, cascade = CascadeType.ALL, mappedBy = "a1")
    protected Collection bCol = new java.util.ArrayList();

    // =======================================================================
    // Business methods for test cases
    public Collection getBCol() {
        TestUtil.logTrace("getBCol");
        return bCol;
    }

    public void setBCol(Collection bCol) {
        TestUtil.logTrace("setBCol");
        this.bCol = bCol;
    }

    public String getAId() {
        return id;
    }

    public String getAName() {
        return name;
    }

    public void setAName(String name) {
        this.name = name;
    }

    public int getAValue() {
        return value;
    }

    public Collection getBInfoFromA() {
        TestUtil.logTrace("getBInfoFromA");
        Vector v = new Vector();
        if (getBCol().size() != 0) {
            Collection bcol = getBCol();
            Iterator iterator = bcol.iterator();
            while (iterator.hasNext()) {
                B b = (B) iterator.next();
                v.add(b);
            }
        }
        return v;
    }
}
