/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.nestedembedding;

import javax.persistence.Embeddable;


@Embeddable
public class ZipCode implements java.io.Serializable{

    protected String zip;
    protected String plusFour;
    
    public ZipCode(){
        // TestUtil.logTrace("ZipCode no arg constructor");
    }

    public ZipCode(String zip, String plusFour) {
        this.zip = zip;
        this.plusFour = plusFour;
    }

    public String getPlusFour() {
        return plusFour;
    }

    public void setPlusFour(String plusFour) {
        this.plusFour = plusFour;
    }

    public String getZip() {
        return zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        if (getZip() != null) {
            result.append("zip: " + getZip());
        } else {
            result.append("zip: null");
        }
        if (getPlusFour() != null) {
            result.append(", plusFour: " + getPlusFour());
        } else {
            result.append(", plusFour: null");
        }
        result.append("]");
        return result.toString();
    }
}
