package com.sun.ts.tests.jpa.core.override.callbacklistener;

import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "NOENTITYLISTENER_TABLE")
public class OverridenCallBack implements java.io.Serializable {

    private Long id;

    public OverridenCallBack() {
    }

    @Id
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void prePersistFromXML() {
        updateCallBackCount("prePersistFromXML");
    }

    public void postRemoveFromXML() {
        updateCallBackCount("postRemoveFromXML");
    }

    public void postUpdateFromXML() {
        updateCallBackCount("postUpdateFromXML");
    }

    public void postLoadFromXML() {
        updateCallBackCount("postLoadFromXML");
    }

    public void postPersistFromXML() {
        updateCallBackCount("postPersistFromXML");
    }

    public void preRemoveFromXML() {
        updateCallBackCount("preRemoveFromXML");
    }

    public void preUpdateFromXML() {
        updateCallBackCount("preUpdateFromXML");
    }

    protected void updateCallBackCount(String callBackKeyName) {
        CallBackCounts.updateCount(callBackKeyName);
    }

    public int hashCode() {
        int hash = 0;
        hash += (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        //TODO:Warning-this method won't work in the case the id fields are not set
        if (!(object instanceof OverridenCallBack)) {
            return false;
        }
        OverridenCallBack other = (OverridenCallBack) object;
        if (this.id != other.id &&
                (this.id == null || !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "override.callbacklistener.OverridenCallBack id=" + id;
    }
}
