package com.sun.ts.tests.jpa.core.override.entitylistener;

import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;

import javax.persistence.PostPersist;
import javax.persistence.PrePersist;

public class ListenerD {

    public ListenerD() {
    }

    @PrePersist
    public void prePersist(Object obj) {
        updateCallBackCount("prePersist");
    }

    @PostPersist
    public void postPersist(Object obj) {
        updateCallBackCount("postPersist");
    }

    protected void updateCallBackCount(String callBackKeyName) {
        CallBackCounts.updateCount(callBackKeyName);
    }
}
