/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 


package com.sun.ts.tests.jpa.jpa22.repeatable.attroverride;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Date;

/*
 * FullTimeEmployee entity extends an MappedSuperClass while overriding
 * mapping information.
 */

@Entity
@Table(name="EMPLOYEE")
@AttributeOverride(name="id",column=@Column(name="ID"))
@AttributeOverride(name="firstName",column=@Column(name="FIRSTNAME"))
@AttributeOverride(name="lastName",column=@Column(name="LASTNAME"))
@AttributeOverride(name="hireDate",column=@Column(name="HIREDATE"))
@Access(AccessType.PROPERTY)
public class FullTimeEmployee extends Employee implements Serializable{

	private static final long serialVersionUID = 22L;
	private float salary;

    public FullTimeEmployee() {
    }

    public FullTimeEmployee(int id, String firstName, String lastName, Date hireDate,
                        float salary)
    {
                super(id, firstName, lastName, hireDate);
                this.salary = salary;
    }

   // ===========================================================
   // getters and setters for the state fields

    @ManyToOne
    @JoinColumn(name="FK_DEPT")
    public Department getDepartment() {
        return department;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return salary;
    }
    public void setSalary(float salary) {
        this.salary = salary;
    }
    
}
