/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.cache.inherit;

import javax.persistence.*;


/*
 * 
 * Product
 *	  
 */


@Entity
@Cacheable(true)
@Table(name = "PRODUCT_TABLE")
@SecondaryTables({@SecondaryTable(name = "PRODUCT_DETAILS", pkJoinColumns = @PrimaryKeyJoinColumn(name = "ID"))})
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "PRODUCT_TYPE", discriminatorType = DiscriminatorType.STRING)
@DiscriminatorValue("Product")
public class Product implements java.io.Serializable {

    // Instance variables
    private String id;
    private int quantity;


    public Product() {
    }

    public Product(String id, int quantity) {
        this.id = id;
        this.quantity = quantity;
    }

    // ===========================================================
    // getters and setters for State fields

    @Id
    @Column(name = "ID")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name = "QUANTITY")
    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int v) {
        this.quantity = v;
    }

    public boolean equals(Object o) {
        Product other;
        boolean same = true;

        if (!(o instanceof Product)) {
            return false;
        }
        other = (Product) o;

        same &= this.id.equals(other.id);

        return same;
    }


    public int hashCode() {
        int myHash;

        myHash = this.id.hashCode();

        return myHash;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", quantity: " + getQuantity());
        result.append("]");
        return result.toString();
    }

}
