/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.joinTable;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name="SCHEMAGENSTUDENT")
public class Student implements java.io.Serializable{
    int studentId;
    String studentName;
    List<Course> courses;

    public Student(){
    }

    public Student(int id){
        this.studentId=id;
    }

    public Student(int id, String name){
       this.studentId = id;
       this.studentName= name;
    }

    @Id
    public int getStudentId() {
        return studentId;
    }

    public void setStudentId(int id) {
        this.studentId = id;
    }

    @ManyToMany(mappedBy = "students", cascade=CascadeType.ALL)
    public List<Course> getCourses() {
        return courses;
    }

     public void setCourses(List<Course> courses) {
        this.courses = courses;
    }


    public String getStudentName() {
        return studentName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }
    
    public int hashCode() {
        
        return this.getStudentId() + this.getStudentName().hashCode();
    }
    
    public boolean equals(Object obj){
        boolean result=false;
        
        if((obj != null) && (obj instanceof Student)){
            Student student = (Student) obj;
            result = (student.getStudentId() == this.getStudentId() &&
                    student.getStudentName().equals(this.getStudentName()));
        }
        return result;
    }

}
