/*
 * Copyright (c) 2013, 2018 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.tableGenerator;

import javax.persistence.*;

@Entity
@Table(name = "SCHEMAGENSIMPLE")
@TableGenerator(name = "mySeAnnotationTableGenerator", table="SE_ANNOTATION_GENERATOR_TABLE",
         pkColumnName = "PK_COL", valueColumnName = "VAL_COL",
  pkColumnValue = "DT1_ID", allocationSize = 1, initialValue = 2)
public class Simple implements java.io.Serializable {

	private static final long serialVersionUID = 22L;
	// ===========================================================
    // instance variables
    int id;

    // ===========================================================
    // constructors
    public Simple() {
    }

    public Simple(int id) {
        this.id = id;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "mySeAnnotationTableGenerator")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

     @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Simple)) return false;

        Simple o1 = (Simple) o;

        boolean result = false;

        if (this.getId() == o1.getId() ) {
            result = true;
        }

        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append("]");
        return result.toString();
    }

}
