/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;

public class HtmlUnitRegExpProxy
extends RegExpImpl {
    private final RegExpProxy wrapped_;

    public HtmlUnitRegExpProxy(RegExpProxy wrapped) {
        this.wrapped_ = wrapped;
    }

    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        if (2 == actionType && args.length == 2 && args[1] instanceof String) {
            String thisString = Context.toString((Object)thisObj);
            String replacement = ((String)args[1]).replaceAll("\\\\", "\\\\\\\\");
            Object arg0 = args[0];
            if (arg0 instanceof String) {
                return StringUtils.replaceOnce((String)thisString, (String)((String)arg0), (String)replacement);
            }
            if (arg0 instanceof NativeRegExp) {
                try {
                    NativeRegExp regexp = (NativeRegExp)arg0;
                    RegExpData reData = new RegExpData(regexp);
                    Pattern pattern = Pattern.compile(reData.getJavaPattern(), reData.getJavaFlags());
                    Matcher matcher = pattern.matcher(thisString);
                    if (reData.hasFlag('g')) {
                        return matcher.replaceAll(replacement);
                    }
                    return matcher.replaceFirst(replacement);
                }
                catch (PatternSyntaxException e) {
                    this.getLog().warn((Object)e);
                }
            }
        } else if (1 == actionType) {
            if (args.length == 0) {
                return null;
            }
            Object arg0 = args[0];
            String thisString = Context.toString((Object)thisObj);
            RegExpData reData = arg0 instanceof NativeRegExp ? new RegExpData((NativeRegExp)arg0) : new RegExpData(Context.toString((Object)arg0));
            Pattern pattern = Pattern.compile(reData.getJavaPattern(), reData.getJavaFlags());
            Matcher matcher = pattern.matcher(thisString);
            if (!matcher.find()) {
                return null;
            }
            int index = matcher.start(0);
            ArrayList<Object> groups = new ArrayList<Object>();
            if (reData.hasFlag('g')) {
                groups.add(matcher.group(0));
                while (matcher.find()) {
                    groups.add(matcher.group(0));
                }
            } else {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    Object group = matcher.group(i);
                    if (group == null) {
                        group = Context.getUndefinedValue();
                    }
                    groups.add(group);
                }
            }
            Scriptable response = cx.newArray(scope, groups.toArray());
            response.put("index", response, (Object)new Integer(index));
            response.put("input", response, (Object)thisString);
            return response;
        }
        return this.wrappedAction(cx, scope, thisObj, args, actionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object wrappedAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this.wrapped_);
            Object object = this.wrapped_.action(cx, scope, thisObj, args, actionType);
            return object;
        }
        finally {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this);
        }
    }

    public Object compileRegExp(Context cx, String source, String flags) {
        return this.wrapped_.compileRegExp(cx, source, flags);
    }

    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        return this.wrapped_.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
    }

    public boolean isRegExp(Scriptable obj) {
        return this.wrapped_.isRegExp(obj);
    }

    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return this.wrapped_.wrapRegExp(cx, scope, compiled);
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    static String escapeJSCurly(String re) {
        re = re.replaceAll("(?<!\\\\)\\{(?!\\d)", "\\\\{");
        re = re.replaceAll("(?<!(\\d,?|\\\\))\\}", "\\\\}");
        return re;
    }

    private static class RegExpData {
        private final String jsSource_;
        private final String jsFlags_;

        RegExpData(NativeRegExp re) {
            String str = re.toString();
            this.jsSource_ = StringUtils.substringBeforeLast((String)str.substring(1), (String)"/");
            this.jsFlags_ = StringUtils.substringAfterLast((String)str, (String)"/");
        }

        public RegExpData(String string) {
            this.jsSource_ = string;
            this.jsFlags_ = "";
        }

        public int getJavaFlags() {
            int flags = 0;
            if (this.jsFlags_.contains("i")) {
                flags |= 2;
            }
            if (this.jsFlags_.contains("m")) {
                flags |= 8;
            }
            return flags;
        }

        public String getJavaPattern() {
            return this.jsRegExpToJavaRegExp(this.jsSource_);
        }

        private String jsRegExpToJavaRegExp(String re) {
            re = re.replaceAll("\\[\\^\\\\\\d\\]", ".");
            re = re.replaceAll("\\[([^\\]]*)\\\\b([^\\]]*)\\]", "[$1\\\\cH$2]");
            re = HtmlUnitRegExpProxy.escapeJSCurly(re);
            return re;
        }

        boolean hasFlag(char c) {
            return this.jsFlags_.indexOf(c) != -1;
        }
    }
}

