/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.io.InvalidObjectException;
import java.io.Serializable;
import org.relaxng.datatype.DatatypeException;

public abstract class WhiteSpaceProcessor
implements Serializable {
    public static final WhiteSpaceProcessor thePreserve = new Preserve();
    public static final WhiteSpaceProcessor theReplace = new Replace();
    public static final WhiteSpaceProcessor theCollapse = new Collapse();
    private static final WhiteSpaceProcessor backwardCompatibiliyHook1 = new WhiteSpaceProcessor(){

        int tightness() {
            return 0;
        }

        public String getName() {
            return "preserve";
        }

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook2 = new WhiteSpaceProcessor(){

        int tightness() {
            return 2;
        }

        public String getName() {
            return "collapse";
        }

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook3 = new WhiteSpaceProcessor(){

        int tightness() {
            return 1;
        }

        public String getName() {
            return "replace";
        }

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };
    private static final long serialVersionUID = 1L;

    abstract int tightness();

    protected static final boolean isWhiteSpace(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected Object readResolve() throws InvalidObjectException {
        try {
            if (this.getClass() == backwardCompatibiliyHook1.getClass()) {
                return thePreserve;
            }
            if (this.getClass() == backwardCompatibiliyHook2.getClass()) {
                return theCollapse;
            }
            if (this.getClass() == backwardCompatibiliyHook3.getClass()) {
                return theReplace;
            }
            return WhiteSpaceProcessor.get(this.getName());
        }
        catch (DatatypeException bte) {
            throw new InvalidObjectException("Unknown Processing Mode");
        }
    }

    public abstract String getName();

    protected static WhiteSpaceProcessor get(String name) throws DatatypeException {
        if ((name = theCollapse.process(name)).equals("preserve")) {
            return thePreserve;
        }
        if (name.equals("collapse")) {
            return theCollapse;
        }
        if (name.equals("replace")) {
            return theReplace;
        }
        throw new DatatypeException(XSDatatypeImpl.localize("WhiteSpaceProcessor.InvalidWhiteSpaceValue", name));
    }

    public static String collapse(String str) {
        return theCollapse.process(str);
    }

    public abstract String process(String var1);

    public static String replace(String str) {
        return theReplace.process(str);
    }

    private static class Collapse
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        int tightness() {
            return 2;
        }

        private Collapse() {
        }

        public String getName() {
            return "collapse";
        }

        public String process(String text) {
            int len = text.length();
            StringBuffer result = new StringBuffer(len);
            boolean inStripMode = true;
            int i = 0;
            while (i < len) {
                char ch = text.charAt(i);
                boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
                if (!inStripMode || !b) {
                    inStripMode = b;
                    if (inStripMode) {
                        result.append(' ');
                    } else {
                        result.append(ch);
                    }
                }
                ++i;
            }
            len = result.length();
            if (len > 0 && result.charAt(len - 1) == ' ') {
                result.setLength(len - 1);
            }
            return result.toString();
        }
    }

    private static class Preserve
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        int tightness() {
            return 0;
        }

        private Preserve() {
        }

        public String getName() {
            return "preserve";
        }

        public String process(String text) {
            return text;
        }
    }

    private static class Replace
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        int tightness() {
            return 1;
        }

        private Replace() {
        }

        public String getName() {
            return "replace";
        }

        public String process(String text) {
            int len = text.length();
            StringBuffer result = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char ch = text.charAt(i);
                if (WhiteSpaceProcessor.isWhiteSpace(ch)) {
                    result.append(' ');
                } else {
                    result.append(ch);
                }
                ++i;
            }
            return result.toString();
        }
    }
}

