/*
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 72458 2013-08-06 19:19:39Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.application.configurablenavigationhandler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.faces.application.Application;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends HttpTCKServlet {

	// Test for getNavigationCase(FacesContext, String, String)
	public void configNavihandlerGetNavigationCaseTest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		FacesContext context = FacesContext.getCurrentInstance();
		Application application = getApplication();
		String fromAct = "#{bogus.postOne}";

		if (application != null) {
			ConfigurableNavigationHandler cnh = (ConfigurableNavigationHandler) application
					.getNavigationHandler();

			if (fromAct.equals(cnh.getNavigationCase(context, fromAct, "")
					.getFromAction())) {
				out.println(JSFTestUtil.PASS);
			} else {
				out.println(JSFTestUtil.FAIL);
			}
		}
	}// End configNavihandlerGetNavigationCaseTest

	// Test for getNavigationCase(FacesContext, String, String) throws
	// NullPointerException
	public void configNavihandlerGetNavigationCaseNPETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = getApplication();

		if (application != null) {
			ConfigurableNavigationHandler cnh = (ConfigurableNavigationHandler) application
					.getNavigationHandler();

			try {
				cnh.getNavigationCase(null, "#{bogus.postOne}", "");
				out.println(JSFTestUtil.FAIL
						+ ": Expected an exception to be thrown, but nothing was!");

			} catch (NullPointerException npe) {
				out.println(JSFTestUtil.PASS);

			} catch (Exception e) {
				out.println(JSFTestUtil.FAIL
						+ ": Expected NullPointerException to be thrown!");
				e.printStackTrace();
			}
		}
	}// End configNavihandlerGetNavigationCaseNPETest

	// Test for getNavigationCases(FacesContext, String, String)
	public void configNavihandlerGetNavigationCasesTest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = getApplication();

		List<String> goldActs = new ArrayList<String>();
		goldActs.add("#{bogus.postOne}");
		goldActs.add("#{bogus.postTwo}");

		if (application != null) {
			ConfigurableNavigationHandler cnh = (ConfigurableNavigationHandler) application
					.getNavigationHandler();

			Map<String, Set<NavigationCase>> navCases = cnh
					.getNavigationCases();

			Iterator<Entry<String, Set<NavigationCase>>> itr = navCases
					.entrySet().iterator();

			while (itr.hasNext()) {
				Entry<String, Set<NavigationCase>> entry = itr.next();

				String key = (String) entry.getKey();

				Iterator<NavigationCase> navItr = entry.getValue().iterator();
				while (navItr.hasNext()) {
					NavigationCase navi = navItr.next();
					String result = navi.getFromAction();

					if (!(goldActs.contains(result))) {
						out.println(JSFTestUtil.FAIL + " Expected " + result
								+ " to be in 'from-view-id: " + key);
						return;
					}
				}
			}

			out.println(JSFTestUtil.PASS);
		}

	}// End configNavihandlerGetNavigationCasesTest
}
