/*
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 72458 2013-08-06 19:19:39Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.application.navigationhandler;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends HttpTCKServlet {

	// Test for HandleNavigationCase(FacesContext, String, String) throws
	// NullPointerException
	public void navigationHandlerHandleNavigationCaseNPETest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter out = response.getWriter();
		Application application = getApplication();

		if (application == null) {
			out.println(JSFTestUtil.APP_NULL_MSG);
			return;
		}

		NavigationHandler nh = application.getNavigationHandler();
		
		JSFTestUtil.checkForNPE(nh, "handleNavigation", new Class<?>[] {
				FacesContext.class, String.class, String.class }, new Object[] {
				null, "#{bogus.postOne}", "" }, out);
		
	}// End navigationHandlerHandleNavigationCaseNPETest

}
