/*
 * Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseBehaviorClient.java 67999 2012-10-09 14:42:29Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.component.behavior.common;

import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public abstract class BaseBehaviorClient extends AbstractUrlClient {

    /*
     * @class.setup_props: webServerHost; webServerPort; ts_home;
     */

    // ----------------------- Behavior Based Tests
    /**
     * testName: behaviorBroadcastNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1016; JSF:JAVADOC:999; JSF:JAVADOC:998;
     *                 JSF:JAVADOC:1003
     * @test_Strategy: Validate that if BehaviorListener in
     *                 BehaviorBase.broadcast(BehaviorListener) is null that a
     *                 NullPointerException is thrown.
     */
    public void behaviorBroadcastNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "behaviorBroadcastNPETest");
	invoke();
    }

    /**
     * testName: behaviorMICInitialStateTest
     * 
     * @assertion_ids: JSF:JAVADOC:1016; JSF:JAVADOC:999; JSF:JAVADOC:1004;
     *                 JSF:JAVADOC:1005; JSF:JAVADOC:1007
     * @test_Strategy: Validate that we get the correct boolean value when using
     *                 the following methods. - BehaviorBase.markInitialState()
     *                 - BehaviorBase.initialStateMarked() -
     *                 BehaviorBase.clearInitialState()
     */
    public void behaviorMICInitialStateTest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "behaviorMICInitialStateTest");
	invoke();
    }

    /**
     * testName: behaviorSITransientTest
     * 
     * @assertion_ids: JSF:JAVADOC:1016; JSF:JAVADOC:999; JSF:JAVADOC:1006;
     *                 JSF:JAVADOC:1008
     * @test_Strategy: Validate that we do not participate in StateSaving or
     *                 Restoring when BehaviorBase.setTransient(false), also
     *                 make sure we get back the correct boolean value form
     *                 BehaviorBase.isTransient().
     */
    public void behaviorSITransientTest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "behaviorSITransientTest");
	invoke();
    }

    // ---------------------ClientBehavior Based Tests

    /**
     * testName: clientBehaviorDecodeNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1016; JSF:JAVADOC:999; JSF:JAVADOC:1012
     * @test_Strategy: Validate that a NullPointerException is thrown if Context
     *                 or Component are null.
     */
    public void clientBehaviorDecodeNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "clientBehaviorDecodeNPETest");
	invoke();
    }

    /**
     * testName: clientBehaviorGetScriptNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1016; JSF:JAVADOC:999; JSF:JAVADOC:1015
     * @test_Strategy: Validate that a NullPointerException is thrown if
     *                 ClientBehaviorContext null.
     * 
     * @since 2.0
     */
    public void clientBehaviorGetScriptNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "clientBehaviorGetScriptNPETest");
	invoke();
    }

} // end of URLClient

