/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BasePartialStateHolderTestServlet.java 64246 2011-12-15 14:42:53Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.component.common;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

/**
 * <p>Base test Servlet for the {@link PartialStateHolder} interface.</p>
 */
public abstract class BasePartialStateHolderTestServlet extends BaseStateHolderTestServlet {

    // ------------------------------------------- Public Methods
    /**
     * <p>
     * Initialize this <code>Servlet</code>.
     * </p>
     * 
     * @param config
     *            this <code>Servlet</code>'s configuration
     * @throws ServletException
     *             if initialization fails
     */
    public void init(ServletConfig config) throws ServletException {
	super.init(config);
    }

    // ------------------------------------------ PartialStateHolder Test Methods
    
    // .markInitialState() 
    // .initialStateMarked()
    // .clearInitialState()
    public void partialStateHolderMICStateTest(HttpServletRequest request,
	    HttpServletResponse response) 
		    throws ServletException, IOException {
       
	PrintWriter out = response.getWriter();

	UIComponent comp = createComponent();
	boolean state;

	// state should be set to 'true' after this call is made.
	comp.markInitialState();
	state = comp.initialStateMarked();

	if (!state) {
	    out.println(JSFTestUtil.FAIL
		    + " Expected State to be true after BehaviorBase.Base.markInitialState()"
		    + " Hed been called!");
	} else {
	    comp.clearInitialState();
	    state = comp.initialStateMarked();

	    if (state) {
		out.println(JSFTestUtil.FAIL
			+ " Expected State to be false after BehaviorBase.Base.clearState()"
			+ " Hed been called!");
	    } else {
		out.println(JSFTestUtil.PASS);
	    }
	}

   } // END behaviorMICInitialStateTest
   
}
