/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TCKValueBinding.java 62525 2011-04-15 12:14:31Z dougd $
 */
 
package com.sun.ts.tests.jsf.api.javax_faces.component.common;

import javax.faces.el.ValueBinding;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.EvaluationException;
import javax.faces.context.FacesContext;
import javax.faces.component.StateHolder;

public class TCKValueBinding extends ValueBinding implements StateHolder{
    
    private ValueBinding binding;
    private String ref;
    
    public TCKValueBinding() {
        super();
    }

    public TCKValueBinding(ValueBinding binding, String ref) {
        this.binding = binding;
        this.ref = ref;
    }

    public Class getType(FacesContext context) throws PropertyNotFoundException {
        return binding.getType(context);
    }

    public Object getValue(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        return binding.getValue(context);
    }

    public boolean isReadOnly(FacesContext context) throws PropertyNotFoundException {
        return binding.isReadOnly(context);
    }

    public void setValue(FacesContext context, Object value) throws EvaluationException, PropertyNotFoundException {
        binding.setValue(context, value);
    }
    
    public Object saveState(FacesContext context) {
        Object values[] = new Object[2];
        values[0] = ref;    
        values[1] = binding;
        return (values);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        // ignore
    }


    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        ref = (String) values[0];
        binding = (ValueBinding) values[1];
    }

    public String getRef() {
        return ref;
    }
}
