/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 65758 2012-04-12 15:33:14Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.uiselectitem;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UISelectItem;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.component.common.BaseComponentTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;


public class TestServlet extends BaseComponentTestServlet {

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType(null);
    }


    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    @Override
    protected UIComponentBase createComponent() {
        return new UISelectItem();
    }
    
// ------------------------------------------- Test Methods ----
    
    public void uiSelectItemGetSetValueTest(HttpServletRequest request,
                                            HttpServletResponse response)
        throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        UISelectItem command = (UISelectItem) createComponent();
        String test = "value";
        command.setValue(test);
        String result = (String) command.getValue();

        if (!test.equals(result)) {
            out.println(JSFTestUtil.FAIL + " UISelectItem.getValue() didn't return" +
                        " the value as set by UISelectItem.setValue().");
            out.println("Expected: " + test);
            out.println("Received: " + result);
            return;
        }

        out.println(JSFTestUtil.PASS);
        
    } // End uiSelectItemGetSetValueTest
    
    public void uiSelectItemGetSetItemDescriptionTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	String test = "Description";
	command.setItemDescription(test);
	String result = command.getItemDescription();

	if (!test.equals(result)) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.getItemDescription() didn't return"
		    + " the value as set by UISelectItem.setItemDescription().");
	    out.println("Expected: " + test);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiSelectItemGetSetItemDescriptionTest
    
    public void uiSelectItemGetSetItemLabelTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	String test = "Label";
	command.setItemLabel(test);
	String result = command.getItemLabel();

	if (!test.equals(result)) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.getItemLabel() didn't return"
		    + " the value as set by UISelectItem.setItemLabel().");
	    out.println("Expected: " + test);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiSelectItemGetSetItemLabelTest
    
    public void uiSelectItemIsSetItemDisabledTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	boolean value = true;
	command.setItemDisabled(value);
	boolean result = command.isItemDisabled();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.isItemDisabled() didn't return"
		    + " the value as set by UISelectItem.setItemDisabled().");
	    out.println("Expected: " + value);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiSelectItemIsSetItemDisabledTest
    
    public void uiSelectItemIsSetItemEscapedTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	boolean value = true;
	command.setItemEscaped(value);
	boolean result = command.isItemEscaped();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.isItemEscaped() didn't return"
		    + " the value as set by UISelectItem.setItemEscaped().");
	    out.println("Expected: " + value);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiSelectItemIsSetItemEscapedTest
    
    public void uiSelectItemIsSetNoSelectionOptionTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	boolean value = true;
	command.setNoSelectionOption(value);
	boolean result = command.isNoSelectionOption();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.isNoSelectionOptionTest() didn't return"
		    + " the value as set by UISelectItem.setNoSelectionOptionTest().");
	    out.println("Expected: " + value);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiSelectItemIsSetNoSelectionOptionTest
    
    public void uiSelectItemGetSetItemValueTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UISelectItem command = (UISelectItem) createComponent();
	boolean test = true;
	
	command.setItemValue(test);
	boolean result = (Boolean) command.getItemValue();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UISelectItem.getItemValue() didn't return"
		    + " the value as set by UISelectItem.setItemValue().");
	    out.println("Expected: " + test);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);

    } // End uiSelectItemGetSetValueTest

}
