/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 66190 2012-06-04 18:34:17Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.uiviewaction;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewAction;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.component.common.BaseComponentTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseComponentTestServlet {
    /**
     * <p>
     * Initializes this {@link javax.servlet.Servlet}.
     * </p>
     * 
     * @param config
     *            this Servlet's configuration
     * @throws ServletException
     *             if an error occurs
     */
    @Override
    public void init(ServletConfig config) throws ServletException {
	super.init(config);
	setRendererType(null);
    }

    /**
     * <p>
     * Creates a new {@link UIComponent} instance.
     * </p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    @Override
    protected UIComponentBase createComponent() {
	return new UIViewAction();
    }

    // ------------------------------------------- UIViewAction Tests

    // UIViewAction.broadcast(FacesContext) throws NullPointerException
    public void uiViewActionBroadcastNPETest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	UIViewAction viewAction = (UIViewAction) createComponent();
	viewAction.setRendererType(null);

	try {
	    viewAction.broadcast(null);
	    out.println(JSFTestUtil.FAIL + "Expected a NullPointerException to be thrown and it wasn't!");
	    
	} catch (NullPointerException npe) {
	    out.println(JSFTestUtil.PASS);
	    
	} catch (Exception e){
	    out.println(JSFTestUtil.FAIL + "Wrong Exception Thrown!" + JSFTestUtil.NL +
		    "Expected: NullPointerException" + JSFTestUtil.NL +
		    "Received: " + e.toString());
	}	
	
    } // End uiViewActionBroadcastNPETest
    
}
