/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 68229 2012-10-23 17:16:06Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.convert.integerconverter;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

import java.io.PrintWriter;

public final class URLClient extends AbstractUrlClient {

    private static final String TYPE = "integer";
    private static final String CONTEXT_ROOT = "/jsf_convert_integer_web";

    public static void main(String[] args) {
	URLClient theTests = new URLClient();
	Status s = theTests.run(args, new PrintWriter(System.out),
		new PrintWriter(System.err));
	s.exit();
    }

    public Status run(String args[], PrintWriter out, PrintWriter err) {
	setContextRoot(CONTEXT_ROOT);
	setServletName(DEFAULT_SERVLET_NAME);
	return super.run(args, out, err);
    }

    /**
     * @class.setup_props: webServerHost; webServerPort; ts_home;
     */

    /** Test Declarations */

    /**
     * @testName: integerConverterGetAsObjectTest
     * 
     * @assertion_ids: JSF:JAVADOC:1574; JSF:JAVADOC:1644; JSF:JAVADOC:1650
     * 
     * @test_Strategy: Ensure the proper result is returned when passing in a
     *                 valid value, null, or a zero-length String.
     */
    public void integerConverterGetAsObjectTest() throws Fault {
	TEST_PROPS
		.setProperty(APITEST, "converterGetAsObjectTest&type=" + TYPE);
	invoke();
    }

    /**
     * @testName: integerConverterGetAsObjectNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1576; JSF:JAVADOC:1646; JSF:JAVADOC:1650
     * 
     * @test_Strategy: Ensure an NPE is thrown if either the context or
     *                 component parameters are null.
     */
    public void integerConverterGetAsObjectNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "converterGetAsObjectNPETest&type="
		+ TYPE);
	invoke();
    }

    /**
     * @testName: integerConverterGetAsStringTest
     * 
     * @assertion_ids: JSF:JAVADOC:1576; JSF:JAVADOC:1647; JSF:JAVADOC:1650
     * 
     * @test_Strategy: Ensure the proper result is returned when passing in a
     *                 valid value, null, or a zero-length String.
     */
    public void integerConverterGetAsStringTest() throws Fault {
	TEST_PROPS
		.setProperty(APITEST, "converterGetAsStringTest&type=" + TYPE);
	invoke();
    }

    /**
     * @testName: integerConverterGetAsStringNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1576; JSF:JAVADOC:1649; JSF:JAVADOC:1650
     * 
     * @test_Strategy: Ensure an NPE is thrown if either the context or
     *                 component parameters are null.
     */
    public void integerConverterGetAsStringNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "converterGetAsStringNPETest&type="
		+ TYPE);
	invoke();
    }

} // end of URLClient
