/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64566 2012-01-10 20:32:01Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.phaseevent;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends HttpTCKServlet {

    public void phaseEventGetPhaseIdTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	FacesContext context = getFacesContext();
	LifecycleFactory factory = (LifecycleFactory) FactoryFinder
		.getFactory(FactoryFinder.LIFECYCLE_FACTORY);

	PhaseEvent pe = new PhaseEvent(context, PhaseId.ANY_PHASE,
		factory.getLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE));

	String golden = PhaseId.ANY_PHASE.getName();
	String result = pe.getPhaseId().getName();
	if (golden.equals(result)) {
	    out.println(JSFTestUtil.PASS);

	} else {
	    out.println(JSFTestUtil.FAIL
		    + " Unexpected result from PhaseEvent.getPhaseId!"
		    + JSFTestUtil.NL + "Expected: " + golden + JSFTestUtil.NL
		    + "Received: " + result);
	}

    } // End phaseEventGetPhaseIdTest

    public void phaseEventGetFacesContextTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();

	String summary = "TCKTest";
	FacesContext context = getFacesContext();
	context.addMessage("cid", new FacesMessage(summary));

	LifecycleFactory factory = (LifecycleFactory) FactoryFinder
		.getFactory(FactoryFinder.LIFECYCLE_FACTORY);

	PhaseEvent pe = new PhaseEvent(context, PhaseId.ANY_PHASE,
		factory.getLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE));

	FacesContext myContext = pe.getFacesContext();
	List<FacesMessage> messages = myContext.getMessageList("cid");
	Iterator<FacesMessage> i = messages.iterator();

	while (i.hasNext()) {
	    FacesMessage fm = i.next();

	    if (summary.equals(fm.getSummary())) {
		out.println(JSFTestUtil.PASS);
		return;

	    } else {
		out.println(JSFTestUtil.FAIL
			+ " Unable to find Message added to FacesContext!");

	    }
	}
    } // End phaseEventGetFacesContextTest

} // End TestServlet
