/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64825 2012-02-07 20:31:07Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.postputflashvalueevent;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.application.Application;
import javax.faces.event.PostPutFlashValueEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseSystemEventTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseSystemEventTestServlet {
    private static final String FLASH_KEY = "key"; 
    
    @Override
    protected SystemEvent createEvent(Object src) {
	return new PostPutFlashValueEvent(FLASH_KEY);
    }
    
    // ------------------------------------------- PostKeepFlashValueEvent
    
    public void postPutFlashValueEventGetKeyTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();

	if (app != null) {
	    PostPutFlashValueEvent pKeep = (PostPutFlashValueEvent) createEvent(app);
	    String result = pKeep.getKey();
	    
	    if (!FLASH_KEY.equals(result)) {
		pw.println(JSFTestUtil.FAIL + " Wrong key value!" + JSFTestUtil.NL +
			"Expected: " + FLASH_KEY + JSFTestUtil.NL +
			"Received: " + result);
	    } else {
		pw.println(JSFTestUtil.PASS);
	    }
	    
	} else {
	    pw.println(JSFTestUtil.FAIL +" Unexpected problem obtaining "
		    + "Application instance.");
	}
    } // End postPutFlashValueEventGetKeyTest
    
} // End TestServlet