/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseValidatorClient.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.validator.common;

import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public abstract class BaseValidatorClient extends AbstractUrlClient {

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	// ------------------------------------------------------- StateHolder Tests
	/*
	 * testName: stateHolderIsSetTransientTest
	 * 
	 * @test_Strategy: Verify {is,set}Transient() - if a value is set, the same
	 * value is returned.
	 */
	public void stateHolderIsSetTransientTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "stateHolderIsSetTransientTest");
		invoke();
	}

	/*
	 * testName: stateHolderSaveRestoreStateTest
	 * 
	 * @test_Strategy: Verify saveState returns a serialized object of the
	 * component's current state and that this state can be restored when
	 * passing this state back into the restoreState() method.
	 */
	public void stateHolderSaveRestoreStateTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "stateHolderSaveRestoreStateTest");
		invoke();
	}

	/*
	 * testName: stateHolderRestoreStateNPETest
	 * 
	 * @test_Strategy: Verify that restoreState throws a NullpointerException if
	 * either FacesContext or state is null.
	 */
	public void stateHolderRestoreStateNPETest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "stateHolderRestoreStateNPETest");
		invoke();
	}

	/*
	 * testName: stateHolderSaveStateNPETest
	 * 
	 * @test_Strategy: Verify that saveState throws a NullpointerException if
	 * either FacesContext null.
	 */
	public void stateHolderSaveStateNPETest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "stateHolderSaveStateNPETest");
		invoke();
	}

	// ------------------------------------------------ PartialStateHolder Tests
	
	/*
	 * testName: validatorPartialStateTest
	 * 
	 * @test_Strategy: Verify that the following method calls perform as 
	 * 				   expected.
	 * 
	 * 				   RegexValidator.clearInitialState();
	 * 				   RegexValidator.initialStateMarked();
	 * 				   RegexValidator.markInitialState();
	 * 
	 * 
	 * @since: 2.0
	 */
	public void validatorPartialStateTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "validatorPartialStateTest");
		invoke();
	}

} // end of URLClient

