/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72262 2013-06-28 15:10:14Z dougd $
 */
package com.sun.ts.tests.jsf.spec.composite.packaging.classpath;

import java.io.PrintWriter;
import java.util.Formatter;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;

public class URLClient extends BaseHtmlUnitClient {

	private static final String SERVLET_MAPPING = "/faces";
	private static final String CONTEXT_ROOT = "/jsf_composite_classpath_web"
			+ SERVLET_MAPPING;
	private static final String TAG_NAME = "span";
	private static final String EXPECTED = "PASSED";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */
	/**
	 * @testName: compositeClasspathPKGTest
	 * @assertion_ids: PENDING
	 * @test_Strategy: The default implementation must support authoring A
	 *                 composite component is declared by creating a Facelets2
	 *                 file inside of a resource library.
	 * 
	 *                 Validate: When packaging the CompositeComponents under
	 *                 various resource locations that the correct Composite
	 *                 Component is found and used.
	 * 
	 * @since 2.0
	 */
	public void compositeClasspathPKGTest() throws Fault {
		StringBuilder messages = new StringBuilder(128);
		Formatter formatter = new Formatter(messages);

		HtmlPage page = getPage(CONTEXT_ROOT + "/pkgTest.xhtml");

		// -------------------------------------------------------------- case 1
		HtmlSpan testOne = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case1");

		if (!validateExistence("case1", TAG_NAME, testOne, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testOne, EXPECTED, formatter);

		handleTestStatus(messages);

	} // END compositeClasspathPKGTest //
}
