/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FlowA.java 70465 2013-03-06 13:40:43Z dougd $
 */

package com.sun.ts.tests.jsf.spec.flows.basicflowcall.beans;

import java.io.Serializable;

import javax.enterprise.inject.Produces;
import javax.faces.flow.Flow;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowBuilderParameter;
import javax.faces.flow.builder.FlowDefinition;

public class FlowA implements Serializable {

	private static final long serialVersionUID = -7623501087369765218L;

	public FlowA() {
	}

	@Produces
	@FlowDefinition
	public Flow buildMyFlow(@FlowBuilderParameter FlowBuilder flowBuilder) {
		String flowId = "flow-a";
		flowBuilder.id("", flowId);
		flowBuilder.viewNode(flowId, "/" + flowId + "/" + flowId + ".xhtml")
				.markAsStartNode();
		flowBuilder.returnNode("taskFlowReturn1").fromOutcome(
				"#{flow_a_Bean.returnValue}");
		flowBuilder.inboundParameter("param1FromFlowB",
				"#{flowScope.param1Value}");
		flowBuilder.inboundParameter("param2FromFlowB",
				"#{flowScope.param2Value}");
		flowBuilder.flowCallNode("callB").flowReference("", "flow-b")
				.outboundParameter("param1FromFlowA", "param1Value")
				.outboundParameter("param2FromFlowA", "param2Value");

		return flowBuilder.getFlow();
	}
}
