/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FlowA.java 69930 2013-02-11 20:14:37Z dougd $
 */

package com.sun.ts.tests.jsf.spec.flows.basicmethodcall.beans;

import java.io.Serializable;
import javax.enterprise.inject.Produces;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.Flow;
import javax.faces.flow.builder.FlowBuilderParameter;
import javax.faces.flow.builder.FlowDefinition;

public class FlowA implements Serializable {

	private static final long serialVersionUID = -7623501087369765218L;

	public FlowA() {
	}

	@Produces
	@FlowDefinition
	public Flow defineFlow(@FlowBuilderParameter FlowBuilder flowBuilder) {
		String flowId = "flow-a";
		flowBuilder.id("", flowId);
		flowBuilder.viewNode(flowId, "/" + flowId + "/" + flowId + ".xhtml")
				.markAsStartNode();
		flowBuilder.returnNode("taskFlowReturn1").fromOutcome(
				"#{flow_a_Bean.returnValue}");
		flowBuilder.methodCallNode("outcome-from-method")
				.expression("#{flow_a_Bean.methodWithOutcome}")
				.defaultOutcome("taskFlowReturn1");
		flowBuilder.methodCallNode("outcome-from-markup")
				.expression("#{flow_a_Bean.voidMethod}")
				.defaultOutcome("taskFlowReturn1");

		return flowBuilder.getFlow();
	}

}
