/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FlowA.java 74385 2015-03-10 11:03:19Z rsoconne $
 */

package com.sun.ts.tests.jsf.spec.flows.basicswitch.beans;

import java.io.Serializable;
import javax.enterprise.inject.Produces;
import javax.faces.flow.Flow;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowDefinition;
import javax.faces.flow.builder.FlowBuilderParameter;


public class FlowA implements Serializable {
    
    private static final long serialVersionUID = -7623501087369765218L;

    public FlowA() {
    }
    
    @Produces @FlowDefinition
    public Flow defineFlow(@FlowBuilderParameter FlowBuilder flowBuilder) {
        String flowId = "flow-a";
        flowBuilder.id("", flowId);
        flowBuilder.viewNode(flowId, "/" + flowId + "/" + flowId + ".xhtml").markAsStartNode();
        flowBuilder.returnNode("taskFlowReturn1").
                fromOutcome("#{flow_a_Bean.returnValue}");
        flowBuilder.switchNode("switchA").defaultOutcome("defaultPage").
                switchCase().condition("#{flow_a_Bean.switchA_Case01}").fromOutcome("page01").
                switchCase().condition("#{flow_a_Bean.switchA_Case02}").fromOutcome("page02").
                switchCase().condition("#{flow_a_Bean.switchA_Case03}").fromOutcome("switchA_result");
        flowBuilder.switchNode("switchB").defaultOutcome("defaultPage").
                switchCase().condition("#{flow_a_Bean.switchB_Case01}").fromOutcome("page01").
                switchCase().condition("#{flow_a_Bean.switchB_Case02}").fromOutcome("switchB_result").
                switchCase().condition("#{flow_a_Bean.switchB_Case03}").fromOutcome("page03");
        flowBuilder.switchNode("switchC").defaultOutcome("#{flow_a_Bean.defaultOutcome}").
                switchCase().condition("#{flow_a_Bean.switchC_Case01}").fromOutcome("page01").
                switchCase().condition("#{flow_a_Bean.switchC_Case02}").fromOutcome("page02").
                switchCase().condition("#{flow_a_Bean.switchC_Case03}").fromOutcome("page03");
        
        return flowBuilder.getFlow();
    }
    
}
