/*
 * Copyright (c) 2009, 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72332 2013-07-11 15:38:53Z dougd $
 */
package com.sun.ts.tests.jsf.spec.render.body;

import com.gargoylesoftware.htmlunit.html.HtmlBody;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.TreeMap;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;
import java.util.ArrayList;
import java.util.List;

public class URLClient extends BaseHtmlUnitClient {

	private static final String CONTEXT_ROOT = "/jsf_render_body_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/**
	 * @testName: bodyRenderPassthroughTest
	 * 
	 * @assertion_ids: PENDING
	 * 
	 * @test_Strategy: Ensure the attributes that are considered passthrough by
	 *                 the specification are rendered as is.
	 * 
	 * @since 2.0
	 */
	public void bodyRenderPassthroughTest() throws Fault {
		StringBuilder messages = new StringBuilder(128);
		Formatter formatter = new Formatter(messages);

		TreeMap<String, String> control = new TreeMap<String, String>();
		control.put("dir", "LTR");
		control.put("lang", "en");
		control.put("onload", "js1");
		control.put("onunload", "js2");
		control.put("onclick", "js3");
		control.put("ondblclick", "js4");
		control.put("onkeydown", "js6");
		control.put("onkeypress", "js7");
		control.put("onkeyup", "js8");
		control.put("onmousedown", "js9");
		control.put("onmousemove", "js10");
		control.put("onmouseout", "js11");
		control.put("onmouseover", "js12");
		control.put("onmouseup", "js13");
		control.put("style", "Color: red;");
		control.put("title", "title");

		List<HtmlPage> pages = new ArrayList<HtmlPage>();
		pages.add(getPage(CONTEXT_ROOT + "/faces/passthroughtest.jsp"));
		pages.add(getPage(CONTEXT_ROOT + "/faces/passthroughtest_facelet.xhtml"));

		for (HtmlPage page : pages) {

			// Facelet Specific PassThrough options
			if (page.getTitleText().contains("facelet")) {
				control.put("foo", "bar");
				control.put("singleatt", "singleAtt");
				control.put("manyattone", "manyOne");
				control.put("manyatttwo", "manyTwo");
				control.put("manyattthree", "manyThree");
			}

			HtmlBody bodyOne = (HtmlBody) page.getBody();

			if (!validateExistence("bodyOne", "body", bodyOne, formatter)) {
				handleTestStatus(messages);
				return;
			}

			validateAttributeSet(control, bodyOne, new String[] { "id",
					"value", "name", "type" }, formatter);

			handleTestStatus(messages);
		}

	} // END bodyRenderPassthroughTest

} // END URLClient
