/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)ServletContextHolder.java	1.1 04/11/05
 */
package com.sun.ts.tests.jsf.spec.webapp.tldsig;

import javax.servlet.ServletContext;

/**
 * This is necessary since the <code>ServletContext</code> is needed in order
 * to run the tests and there is no way to get access to the
 * <code>ServletContext</code> when running TagExtraInfo.validate() is called.  
 *
 * @see SignatureInitListener
 */
public class ServletContextHolder {

    private static ServletContext servletContext;


    // ---------------------------------------------------------- Public Methods


    public static ServletContext getServletContext() {

        return servletContext;

    } // END getServletContext


    public static void setServletContext(ServletContext context) {

        servletContext = context;

    } // END setServletContext
    
}
