/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.propertyorder.model;

import javax.json.bind.annotation.JsonbPropertyOrder;

@JsonbPropertyOrder({"longInstance", "intInstance", "stringInstance"})
public class PartialOrderContainer {
    private int intInstance;
    private String stringInstance;
    private long longInstance;
    private int anIntInstance;
    private int anotherIntInstance;
    private int yetAnotherIntInstance;

    public int getAnIntInstance() {
    	intInstance -=10;
		return anIntInstance;
	}

	public void setAnIntInstance(int anIntInstance) {
		intInstance -=30;
		this.anIntInstance = anIntInstance;
	}

	public int getAnotherIntInstance() {
		intInstance -=100;
		return anotherIntInstance;
	}

	public void setAnotherIntInstance(int anotherIntInstance) {
		intInstance -=300;
		this.anotherIntInstance = anotherIntInstance;
	}

	public int getYetAnotherIntInstance() {
		intInstance -=1000;
		return yetAnotherIntInstance;
	}

	public void setYetAnotherIntInstance(int yetAnotherIntInstance) {
		intInstance -=3000;
		this.yetAnotherIntInstance = yetAnotherIntInstance;
	}

	public String getStringInstance() {
        return stringInstance;
    }

    public void setStringInstance(String stringInstance) {
        this.stringInstance = stringInstance;
        if (intInstance == 1) {
            intInstance = 2;
        }
    }

    public int getIntInstance() {
        return intInstance;
    }

    public void setIntInstance(int intInstance) {
        this.intInstance = intInstance;
    }

    public long getLongInstance() {
        return longInstance;
    }

    public void setLongInstance(long longInstance) {
        this.longInstance = longInstance;
        if (intInstance == 2) {
            intInstance = 3;
        }
    }
}
