/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.ErrorFormatPane;
import com.sun.javatest.exec.ImagePane;
import com.sun.javatest.exec.MusicPane;
import com.sun.javatest.exec.NavigationPane;
import com.sun.javatest.exec.TextPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.HTMLWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class MultiFormatPane
extends JPanel
implements Printable {
    private static final String SUPPORTED_MEDIA_RESOURCE_EXTENSIONS = ".wav .au .aif .mid .midi .rmf .jpeg .jpg .gif .png";
    private JScrollPane scrllBody;
    public static final int TEXT = 0;
    public static final int IMAGE = 1;
    public static final int AUDIO = 2;
    public static final int ERROR = 3;
    private File baseDir;
    private URL currURL;
    private TextPane textPane;
    private MusicPane musicPane;
    private ImagePane imagePane;
    private ErrorFormatPane errorPane;
    private UIFactory uif;
    private String uiKey;
    private Listener listener;
    private JTextField noteField;
    private NavigationPane navPane;
    private HashMap modesToPanes;

    public MultiFormatPane(UIFactory uif) {
        this.uif = uif;
        this.listener = new Listener();
        this.initGUI();
        this.modesToPanes = new HashMap();
        this.addMediaPane(0, this.textPane);
        this.addMediaPane(2, this.musicPane);
        this.addMediaPane(1, this.imagePane);
        this.addMediaPane(3, this.errorPane);
    }

    public void setNoteField(JTextField noteField) {
        this.noteField = noteField;
    }

    public void setNavigationPane(NavigationPane navPane) {
        this.navPane = navPane;
    }

    public void addMediaPane(int mode, MediaPane pane) {
        this.modesToPanes.put(mode, pane);
    }

    public MediaPane getMediaPane(int mode) {
        return (MediaPane)this.modesToPanes.get(mode);
    }

    public void clear() {
        this.currURL = null;
        if (this.navPane != null) {
            this.navPane.clear();
        }
        this.musicPane.stopAudio();
    }

    public URL getPage() {
        return this.currURL;
    }

    public int getCurrentMode() {
        return this.getCurrentPane().getMode();
    }

    public MediaPane getCurrentPane() {
        return (MediaPane)((Object)this.scrllBody.getViewport().getComponent(0));
    }

    void setBaseDirectory(File base) {
        this.baseDir = base;
    }

    File getBaseDirectory() {
        return this.baseDir;
    }

    void setDefaultView() {
        this.textPane.setDocument(new HTMLDocument());
        this.textPane.showTextArea();
    }

    private void initGUI() {
        this.uif.initPanel(this, "mfp", false);
        this.textPane = new TextPane(this.uif, "mfp.textPane", null);
        this.textPane.addHyperlinkListener(this.listener);
        this.scrllBody = this.uif.createScrollPane(this.textPane, 20, 30);
        this.textPane.setParent(this.scrllBody);
        this.musicPane = new MusicPane(this.uif, "mfp.audioPane", this.scrllBody);
        this.imagePane = new ImagePane(this.uif, "mfp.imagePanelbl", this.scrllBody);
        this.errorPane = new ErrorFormatPane(this.uif, "mfp.errorPane", this.scrllBody);
        this.scrllBody.setViewportView(this.textPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrllBody, "Center");
    }

    public void loadPage(URL url) {
        if (this.currURL != null && url.toString().equals(this.currURL.toString())) {
            return;
        }
        this.currURL = url;
        String protocol = url.getProtocol();
        File file = new File(url.getFile());
        if (protocol.equals("file") && file.isDirectory()) {
            String list = this.listLocalDirectory(file);
            this.textPane.showText(list, "text/html");
            ((HTMLDocument)this.textPane.getDocument()).setBase(url);
        } else if (ImagePane.isImageResource(url)) {
            this.imagePane.showImage(url);
        } else if (MusicPane.isAudioResource(url)) {
            this.musicPane.showAudio(url);
        } else if (this.isMediaResourceCorrupted(url)) {
            this.errorPane.showError(this.uif.getI18NString("mfp.errorPaneLbl.corrupted"));
        } else if (TextPane.isTextResource(url)) {
            this.textPane.showText(url);
        } else if (url.getProtocol().equalsIgnoreCase("http")) {
            this.textPane.showText(url);
        } else {
            int response = this.uif.showYesNoDialog("mfp.unknownTypeDlg");
            if (response == 0) {
                this.textPane.showText(url);
            } else {
                this.errorPane.showError(this.uif.getI18NString("mfp.errorPaneLbl.unsupported"));
            }
        }
        if (this.navPane != null) {
            this.navPane.processURL(url);
        }
    }

    public void showText(String text, String MIME) {
        this.textPane.showText(text, MIME);
        this.currURL = null;
    }

    public void showText(URL url) {
        this.textPane.showText(url);
    }

    public void showAudio(URL url) {
        this.musicPane.showAudio(url);
    }

    public void stopAudio() {
        this.musicPane.stopAudio();
    }

    public void showImage(URL url) {
        this.imagePane.showImage(url);
    }

    public void showError(String errorMessage) {
        this.errorPane.showError(errorMessage);
    }

    private boolean isMediaResourceSupported(URL url) {
        return ImagePane.isImageResource(url) || MusicPane.isAudioResource(url);
    }

    private boolean isMediaResourceCorrupted(URL url) {
        String filename = url.getFile();
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        return SUPPORTED_MEDIA_RESOURCE_EXTENSIONS.indexOf(ext = ext.toLowerCase()) != -1 && !this.isMediaResourceSupported(url);
    }

    private String listLocalDirectory(File dir) {
        String p;
        if (!dir.isAbsolute()) {
            dir = dir.getAbsoluteFile();
        }
        String displayPath = dir.getPath();
        if (this.baseDir != null && (p = this.baseDir.getParent()) != null && displayPath.startsWith(p) && displayPath.length() > p.length() && (displayPath = displayPath.substring(p.length())).startsWith(File.separator)) {
            displayPath = displayPath.substring(1);
        }
        String[] filelist = dir.list();
        StringWriter sw = new StringWriter();
        try {
            HTMLWriter out = new HTMLWriter((Writer)sw, this.uif.getI18NResourceBundle());
            out.startTag("html");
            out.startTag("head");
            out.startTag("title");
            out.write(displayPath);
            out.endTag("title");
            out.endTag("head");
            out.startTag("body");
            out.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
            out.startTag("h3");
            out.writeI18N("mfp.head", displayPath);
            out.endTag("h3");
            out.startTag("ul");
            out.writeStyleAttr("margin-left:0");
            File parent = dir.getParentFile();
            if (parent != null) {
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", "up");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.startTag("a");
                    out.writeAttr("href", parent.toURL().toString());
                    out.writeI18N("mfp.parent");
                    out.endTag("a");
                }
                catch (MalformedURLException e) {
                    out.writeI18N("mfp.parent");
                }
            }
            for (int i = 0; i < filelist.length; ++i) {
                File file = new File(dir, filelist[i]);
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", file.isDirectory() ? "folder" : "file");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.writeLink(file.toURL(), file.getName());
                    continue;
                }
                catch (MalformedURLException e) {
                    out.write(file.getName());
                }
            }
            out.endTag("ul");
            out.endTag("body");
            out.endTag("html");
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int response = 1;
        Graphics2D g2 = (Graphics2D)g;
        Component componentToBePrinted = this.scrllBody.getComponent(0);
        int mode = this.getCurrentMode();
        switch (mode) {
            case 0: {
                componentToBePrinted = this.textPane;
                break;
            }
            case 1: {
                componentToBePrinted = this.imagePane;
                break;
            }
        }
        this.disableDoubleBuffering(componentToBePrinted);
        Dimension d = componentToBePrinted.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            g2.translate(pf.getImageableX(), pf.getImageableY());
            g2.translate(0.0, (double)(-pageIndex) * pageHeight);
            g2.scale(scale, scale);
            componentToBePrinted.paint(g2);
            this.enableDoubleBuffering(componentToBePrinted);
            response = 0;
        }
        return response;
    }

    private void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    private void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    private class Listener
    implements HyperlinkListener {
        private Listener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            HyperlinkEvent.EventType et = e.getEventType();
            if (et == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    this.processFrameLink(e);
                } else {
                    MultiFormatPane.this.musicPane.stopAudio();
                    if (e.getURL() == null && e.getDescription().startsWith("#")) {
                        this.processSharpLink(e);
                    } else {
                        this.processGeneralLink(e);
                    }
                }
            } else if (et == HyperlinkEvent.EventType.ENTERED) {
                URL u = e.getURL();
                if (u != null) {
                    MultiFormatPane.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                    if (MultiFormatPane.this.noteField != null) {
                        MultiFormatPane.this.noteField.setText(u.toString());
                    }
                }
            } else if (et == HyperlinkEvent.EventType.EXITED) {
                MultiFormatPane.this.textPane.setCursor(Cursor.getPredefinedCursor(0));
                if (MultiFormatPane.this.noteField != null) {
                    MultiFormatPane.this.noteField.setText("");
                }
            }
        }

        private void processFrameLink(HyperlinkEvent e) {
            HTMLDocument doc = (HTMLDocument)((JEditorPane)e.getSource()).getDocument();
            doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
        }

        private void processSharpLink(HyperlinkEvent e) {
            String desc = e.getDescription();
            if (!desc.startsWith("#")) {
                return;
            }
            MultiFormatPane.this.textPane.scrollToReference(desc.substring(1));
        }

        private void processGeneralLink(HyperlinkEvent e) {
            int pos;
            URL correctURL = e.getURL();
            HTMLDocument doc = (HTMLDocument)((JEditorPane)e.getSource()).getDocument();
            if (doc != null && MultiFormatPane.this.currURL != null && !doc.getBase().toString().equals(MultiFormatPane.this.currURL.toString())) {
                MultiFormatPane.this.currURL = doc.getBase();
            }
            if (correctURL.getProtocol().equals("file") && (pos = correctURL.toString().indexOf("?")) >= 0) {
                try {
                    correctURL = new URL(correctURL.toString().substring(0, pos));
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            MultiFormatPane.this.loadPage(correctURL);
        }
    }

    public static interface MediaPane {
        public int getMode();

        public void changeURL(URL var1);

        public void setParent(JScrollPane var1);
    }
}

