/*
 * Copyright (c) 2017 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import javax.json.JsonPatch;

// $Id: PatchOperationEnum.java 74776 2017-01-11 10:51:15Z tkraus $
/**
 * RFC 6902: JavaScript Object Notation (JSON) Patch compatibility tests.<br>
 * {@see <a href="https://tools.ietf.org/html/rfc6902">RFC 6902</a>}.
 * <p>
 * Test {@link JsonPatch.Operation} enumeration.
 */
public class PatchOperationEnum {
    
    /**
     * Creates an instance of {@link JsonPatch.Operation} enumeration test.
     */
    PatchOperationEnum() {
        super();
    }

    /**
     * Test {@link JsonPatch.Operation} enumeration. Suite entry point.
     * @return Result of all tests in this suite.
     */
    TestResult test() {
        final TestResult result = new TestResult("JsonPatch.Operation enumeration test");
        TestUtil.logMsg("JsonPatch.Operation enumeration test");
        testOperationName(result);
        testOperationValueOf(result);
        return result;
    }

    /**
     * Test {@link JsonPatch.Operation#fromOperationName(String)} and {@link JsonPatch.Operation#operationName()}
     * methods.
     * @param result Tests result record.
     */
    private void testOperationName(final TestResult result) {
        TestUtil.logMsg(" - fromOperationName(String) and operationName(String)");
        for (final JsonPatch.Operation op : JsonPatch.Operation.values()) {
            final String opName = op.operationName();
            final JsonPatch.Operation opOut = JsonPatch.Operation.fromOperationName(opName);
            final int opNameLen = opName.length();
            boolean opNameLc = true;
            for (int i = 0; opNameLc && i < opNameLen; i++) {
                opNameLc = Character.isLowerCase(opName.charAt(i));
            }
            if (!opNameLc) {
                result.fail("operationName(String)", "Returned value " + opName + " is not lower case String");
            }
            if (op != opOut) {
                result.fail("fromOperationName(String) and operationName(String)",
                        "Returned operation " + opOut.name() + " shall be " + op.name());
            }
        }
    }

    /**
     * Test {@code JsonPatch.Operation#valueOf(String)} method.
     * @param result Tests result record.
     */
    private void testOperationValueOf(final TestResult result) {
        TestUtil.logMsg(" - valueOf(String)");
        for (final JsonPatch.Operation op : JsonPatch.Operation.values()) {
            final String opName = op.name();
            final JsonPatch.Operation opOut = JsonPatch.Operation.valueOf(opName);
             if (op != opOut) {
                result.fail("valueOf(String)",
                        "Returned operation " + opOut.name() + " shall be " + op.name());
            }
        }
    }

}
