/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.compelresolver;

import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import com.sun.ts.tests.jsp.common.util.InstallCompositeELResolverListener;
import javax.el.ELContext;
import javax.el.CompositeELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class CompositeELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

        StringBuffer buf = new StringBuffer("");
        JspWriter out = getJspContext().getOut();
        ELContext context = getJspContext().getELContext();
        CompositeELResolver compResolver = 
                InstallCompositeELResolverListener.getCompositeELResolver();

        try {
            boolean pass = ResolverTest.testCompositeELResolver(context,
                    compResolver, buf);
            out.println(buf.toString());
            if (pass == true) out.println("Test PASSED");
        } catch (Throwable t) {
            out.println(buf.toString());
            JspTestUtil.handleThrowable(t, out, "CompositeELResolverTag");
        }
    }
}
