/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FailingTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)FailingTag.java 1.1 10/31/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class FailingTag extends TagSupport {

    /**
     * Default constructor.
     */
    public FailingTag() {
        super();
    }

    /**
     * This method shouldn't be invoked.
     * @return Tag.SKIP_BODY
     * @throws JspException - if an unexpected error occurs
     */
    public int doEndTag() throws JspException {
        JspTestUtil.debug("[FailingTag] in doEndTag()");
        try {
            pageContext.getOut().println("Test FAILED.  Default behavior of " +
                "SimpleTagSupport.doTag() is to do nothing.  This handler should" +
                " not have been invoked.");
        } catch (IOException ioe) {
            throw new JspException("Test FAILED. Unexpected IOException thrown.", ioe);
        }
        return SKIP_BODY;
    }
}
