/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: JspFunctions.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.common.util;

/**
 * Defines functions to be used in EL expressions and
 * various other tests.
 */

public class JspFunctions {

    /**
     * Private construtor as all methods are static.
     */
    private JspFunctions() {
    }

    /**
     * Returns the provided string in all lower case characters.
     * @param value - string to lower case
     * @return the provided value as lower case characters
     */
    public static String lowerCase(String value) {
        return value.toLowerCase();
    }

    /**
     * Returns the provided string in all upper case characters
     * @param value - string to upper case
     * @return the provided value as upper case characters
     */
    public static String upperCase(String value) {
        return value.toUpperCase();
    }
}
