/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DeferredSyntaxAllowedAsLiteralTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.spec.configuration.charsequence;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class DeferredSyntaxAllowedAsLiteralTag extends SimpleTagSupport {

    private String poundExpr;

    public void setPoundExpr(String poundExpr) {
        this.poundExpr = poundExpr;
    }

    public void doTag() throws JspException, IOException {
        JspWriter out = getJspContext().getOut();

        try {
            out.println("From tag handler: " + poundExpr);
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "DeferredSyntaxAllowedAsLiteralTag");
        }
    }
}
